// rxMode values
#define EVENTDATA		1
#define EVENTDATA_LONG	2
#define COMMAND			3

// commands to PIC from MATLAB
#define BYTEWRAPPER_8		101
#define BYTEWRAPPER_16		102
#define BYTEWRAPPER_32		104 
#define EXECUTE				3
#define PAUSE				4
#define RESET				5
#define RETURN_TABLE		6


int rxMode = COMMAND;
int curCommand = 0;
long unsigned int regHold=0;
long int *ptrReset;
long int *ptr;
int inputCellCount = 0;
//int leftover = 0;
//int leftoverFlag=0;


int inputByteCount = 0;
long unsigned int inputTemp =0;


int *masterPtr ;	
int i = 0;

int realTime=0;
		
void serialRead(void) {
	regHold = U1RXREG;	
	if (realTime) {
		realTimeRead(regHold);
	} else {	
		switch (rxMode) {
			case EVENTDATA:
				*(ptr)++ = regHold;
				inputCellCount++;
				rxMode = COMMAND;
				break;				
			case EVENTDATA_LONG:
				inputTemp = inputTemp + (regHold << 8*inputByteCount);
				inputByteCount++;					
				if (inputByteCount == (curCommand-100)) {
					*(ptr)++ = inputTemp;
					inputCellCount++;
					inputTemp = 0;
					inputByteCount = 0;
					rxMode = COMMAND;
				}
				break;	
			case COMMAND:
				curCommand = regHold;
				switch (curCommand) {
					case BYTEWRAPPER_8:
						rxMode = EVENTDATA;
						inputTemp = 0;
						break;
					case BYTEWRAPPER_16:
						rxMode = EVENTDATA_LONG;
						inputByteCount = 0;
						inputTemp = 0;
						break;	
					case BYTEWRAPPER_32:
						rxMode = EVENTDATA_LONG;
						inputByteCount = 0;
						inputTemp = 0;
						break;
					//case BYTEWRAPPER_64:
					//	rxMode = EVENTDATA_LONG;
					//	inputByteCount = 0;
					//	inputTemp = 0;
					//	break;
					case EXECUTE:
						T1CONbits.TON = 1;      //turn on timer 1 
						_T1IE = 1;				//enable T1 interrupt (increments masterTick)
						break;
					case PAUSE:
						T1CONbits.TON = 0;      
						_T1IE = 0;	
						break;
					case RESET:
						T1CONbits.TON = 0;      
						_T1IE = 0;	
						T2CONbits.TON = 0;      
						_T2IE = 0;
						allOff();
						L1 = 0; 
						L2 = 0;
						L3 = 0;
						L4 = 0;
						L5 = 0;
						L6 = 0;
						//clear eventTable and ptr:
						ptr =eventTable;
						for (i=0;i<=inputCellCount; i++) {
							*(ptr + i) = 0;
						}
						inputCellCount = 0;	
						
						
						//clear masterLEDtable and turn off all LEDs
						for (i = 0;i<=sizeof(masterLEDtable)/sizeof(int); i++) {
							*(masterPtr + i) = 0;
						}
						for (i=0;i<=8;i++) {
							outputBank(i);
						}	
						
						//int qwer =sizeof(masterLEDtable);
						
						
						curEventTime = 0;
						curEventNum = 0;
						masterTick = 0;
						break;							
					
				}
				break;
		}			
	}		

}
	
	
	
	




void realTimeRead(int reg_hold) {
	switch(reg_hold) {

		case 1:
			R1 = 1;		//turn on pin R1
			break;
		case 2:
			R2 = 1;
			break;
		case 3:
			R3 = 1;
			break;
		case 4:
			R4 = 1;
			break;
		case 5:
			R5 = 1;
			break;
		case 6:
			R6 = 1;
			break;
		case 7:
			R7 = 1;
			break;
		case 8:
			R8 = 1;
			break;
		case 9:
			R9 = 1;
			break;
		case 10:
			R10 = 1;
			break;
		case 11:
			R11 = 1;
			break;
		case 12:
			R12 = 1;
			break;
		case 13:
			R13 = 1;
			break;
		case 14:
			R14 = 1;
			break;
		case 15:
			R15 = 1;
			break;
		case 16:
			R16 = 1;
			break;
		case 17:
			R17 = 1;
			break;
		case 18:
			R18 = 1;
			break;
		case 19:
			R19 = 1;
			break;
		case 20:
			R20 = 1;
			break;
		case 21:
			R21 = 1;
			break;
		case 22:
			R22 = 1;
			break;
		case 23:
			R23 = 1;
			break;
		case 24:
			R24 = 1;
			break;
		case 25:
			R25 = 1;
			break;
		case 26:
			R26 = 1;
			break;
		case 27:
			R27 = 1;
			break;
		case 28:
			R28 = 1;
			break;
		case 29:
			R29 = 1;
			break;
		//commands larger than 29: wrap around.  turn off pin Rx where x=command-29
		default:
			switch (reg_hold-29) {
				case 1:
					R1 = 0;		//turn on pin R1
					break;
				case 2:
					R2 = 0;
					break;
				case 3:
					R3 = 0;
					break;
				case 4:
					R4 = 0;
					break;
				case 5:
					R5 = 0;
					break;
				case 6:
					R6 = 0;
					break;
				case 7:
					R7 = 0;
					break;
				case 8:
					R8 = 0;
					break;
				case 9:
					R9 = 0;
					break;
				case 10:
					R10 = 0;
					break;
				case 11:
					R11 = 0;
					break;
				case 12:
					R12 = 0;
					break;
				case 13:
					R13 = 0;
					break;
				case 14:
					R14 = 0;
					break;
				case 15:
					R15 = 0;
					break;
				case 16:
					R16 = 0;
					break;
				case 17:
					R17 = 0;
					break;
				case 18:
					R18 = 0;
					break;
				case 19:
					R19 = 0;
					break;
				case 20:
					R20 = 0;
					break;
				case 21:
					R21 = 0;
					break;
				case 22:
					R22 = 0;
					break;
				case 23:
					R23 = 0;
					break;
				case 24:
					R24 = 0;
					break;
				case 25:
					R25 = 0;
					break;
				case 26:
					R26 = 0;
					break;
				case 27:
					R27 = 0;
					break;
				case 28:
					R28 = 0;
					break;
				case 29:
					R29 = 0;
					break;
			}
			break;
	}
}
